unit JVData_Structure;

interface
uses
  SysUtils;
type

    //========================================================================
    //  JRA-VAN Data Lab. JV-Data\
    //
    //
    //   쐬: JRA-VAN \tgEFAH[ 
    //
    //========================================================================
    //   (C) JRA SYSTEM SERVICE CO.,LTD. 2007 All rights reserved
    //========================================================================
    

    ////////// ʍ\ //////////


    //<N>
    _YMD = record
        Year    : array[0..3] of Char;                          //N
        Month   : array[0..1] of Char;                          //
        Day     : array[0..1] of Char;                          //
    end;


    //<b>
    _HMS = record
        Hour   : array[0..1] of Char;                           //
        Minute : array[0..1] of Char;                           //
        Second : array[0..1] of Char;                           //b
    end;


    //<>
    _HM = record
        Hour   : array[0..1] of Char;                           //
        Minute : array[0..1] of Char;                           //
    end;


    //<>
    _MDHM = record
        Month  : array[0..1] of Char;                           //
        Day    : array[0..1] of Char;                           //
        Hour   : array[0..1] of Char;                           //
        Minute : array[0..1] of Char;                           //
    end;


    //<R[hwb_>
    _RECORD_ID = record
        RecordSpec : array[0..1] of Char;                       //R[h
        DataKubun  : array[0..0] of Char;                       //f[^敪
        MakeDate   : _YMD;                                      //f[^쐬N
    end;


    //<ʏP>
    _RACE_ID = record
        Year     : array[0..3]  of Char;                        //JÔN
        MonthDay : array[0..3]  of Char;                        //JÌ
        JyoCD    : array[0..1]  of Char;                        //nR[h
        Kaiji    : array[0..1]  of Char;                        //JÉ[N]
        Nichiji  : array[0..1]  of Char;                        //JÓ[N]
        RaceNum  : array[0..1]  of Char;                        //[Xԍ
    end;


    //<ʏQ>
    _RACE_ID2 = record
        Year     : array[0..3]  of Char;                        //JÔN
        MonthDay : array[0..3]  of Char;                        //JÌ
        JyoCD    : array[0..1]  of Char;                        //nR[h
        Kaiji    : array[0..1]  of Char;                        //JÉ[N]
        Nichiji  : array[0..1]  of Char;                        //JÓ[N]
    end;


    //<񐔁iTCY3bytej>
    _CHAKUKAISU3_INFO = record
        Chakukaisu : array[0..5,0..2] of Char;                  //
    end;

    //<񐔁iTCY4bytej>
    _CHAKUKAISU4_INFO = record
        Chakukaisu : array[0..5,0..3] of Char;                  //
    end;

    //<񐔁iTCY5bytej>
    _CHAKUKAISU5_INFO = record
        Chakukaisu : array[0..5,0..4] of Char;                  //
    end;

    //<񐔁iTCY6bytej>
    _CHAKUKAISU6_INFO = record
        Chakukaisu : array[0..5,0..5] of Char;                  //
    end;


    //<{NE݌vя>
    _SEI_RUIKEI_INFO = record
        SetYear        : array[0..3]      of Char;              //ݒN
        HonSyokinTotal : array[0..9]      of Char;              //{܋v
        FukaSyokin     : array[0..9]      of Char;              //t܋v
        ChakuKaisu     : array[0..5,0..5] of Char;              //
    end;


    //<ŋߏd܏>
    _SAIKIN_JYUSYO_INFO = record
        SaikinJyusyoid : _RACE_ID;                               //<NR>
        Hondai         : array[0..59] of Char;                  //{
        Ryakusyo10     : array[0..19] of Char;                  //10
        Ryakusyo6      : array[0..11] of Char;                  //6
        Ryakusyo3      : array[0..5]  of Char;                  //3
        GradeCD        : array[0..0]  of Char;                  //O[hR[h
        SyussoTosu     : array[0..1]  of Char;                  //o
        KettoNum       : array[0..9]  of Char;                  //o^ԍ
        Bamei          : array[0..35] of Char;                  //n
    end;


    //<{NEONE݌vя>
    _HON_ZEN_RUIKEISEI_INFO = record
        SetYear            : array[0..3] of Char;               //ݒN
        HonSyokinHeichi    : array[0..9] of Char;               //n{܋v
        HonSyokinSyogai    : array[0..9] of Char;               //Q{܋v
        FukaSyokinHeichi   : array[0..9] of Char;               //nt܋v
        FukaSyokinSyogai   : array[0..9] of Char;               //Qt܋v
        ChakuKaisuHeichi   : _CHAKUKAISU6_INFO;                 //n
        ChakuKaisuSyogai   : _CHAKUKAISU6_INFO;                 //Q
        ChakuKaisuJyo      : array[0..19]of _CHAKUKAISU6_INFO;  //nʒ
        ChakuKaisuKyori    : array[0..5] of _CHAKUKAISU6_INFO;  //ʒ
    end;


    //<[X>
    _RACE_INFO = record
        YoubiCD    : array[0..0]   of Char;                     //jR[h
        TokuNum    : array[0..3]   of Char;                     //ʋԍ
        Hondai     : array[0..59]  of Char;                     //{
        Fukudai    : array[0..59]  of Char;                     //
        Kakko      : array[0..59]  of Char;                     //JbR
        HondaiEng  : array[0..119] of Char;                     //{艢
        FukudaiEng : array[0..119] of Char;                     //艢
        KakkoEng   : array[0..119] of Char;                     //JbR
        Ryakusyo10 : array[0..19]  of Char;                     //̂PO
        Ryakusyo6  : array[0..11]  of Char;                     //̂U
        Ryakusyo3  : array[0..5]   of Char;                     //̂R
        Kubun      : array[0..0]   of Char;                     //敪
        Nkai       : array[0..2]   of Char;                     //d܉[N]
    end;


    //<VEn>
    _TENKO_BABA_INFO = record
        TenkoCD    : array[0..0]  of Char;                      //VR[h
        SibaBabaCD : array[0..0]  of Char;                      //ŔnԃR[h
        DirtBabaCD : array[0..0]  of Char;                      //_[gnԃR[h
    end;


    //<R[h>
    _RACE_JYOKEN = record
        SyubetuCD   : array[0..1]      of Char;                 //ʃR[h
        KigoCD      : array[0..2]      of Char;                 //LR[h
        JyuryoCD    : array[0..0]      of Char;                 //dʎʃR[h
        JyokenCD    : array[0..4,0..2] of Char;                 //R[h
    end;


	//<RύX>
    _JC_INFO = record
        Futan       : array[0..2]      of Char;                 //Sd
        KisyuCode   : array[0..4]      of Char;                 //RR[h
        KisyuName   : array[0..33]     of Char;                 //R薼
        MinaraiCD   : array[0..0]      of Char;                 //R茩KR[h
    end;

	//<ύX>
    _TC_INFO = record
        Ji       : array[0..1]      of Char;                 //
        Fun      : array[0..1]      of Char;                 //
    end;
  
	//<R[XύX>
    _CC_INFO = record
        Kyori       : array[0..3]      of Char;                 //
        TruckCD      : array[0..1]      of Char;                 //gbN
    end;


    ////////// f[^\ //////////


    //****** PDʓo^n ****************************************

    JV_TK_TOKUUMA = record
        head          : _RECORD_ID;                              //<R[hwb_[>
        id            : _RACE_ID;                                //<ʏP>
        RaceInfo      : _RACE_INFO;                              //<[X>
        GradeCD       : array[0..0] of Char;                    //O[hR[h
        JyokenInfo    : _RACE_JYOKEN;                            //<R[h>
        Kyori         : array[0..3] of Char;                    //
        TrackCD       : array[0..1] of Char;                    //gbNR[h
        CourseKubunCD : array[0..1] of Char;                    //R[X敪
        HandiDate     : _YMD;                                   //nf\
        TorokuTosu    : array[0..2] of Char;                    //o^

        TokuUmaInfo : array[0..299] of record                   //<o^n>
            Num               : array[0..2]   of Char;          //A
            KettoNum          : array[0..9]   of Char;          //o^ԍ
            Bamei             : array[0..35]  of Char;          //n
            UmaKigoCD         : array[0..1]   of Char;          //nLR[h
            SexCD             : array[0..0]   of Char;          //ʃR[h
            TozaiCD           : array[0..0]   of Char;          //tR[h
            ChokyosiCode      : array[0..4]   of Char;          //tR[h
            ChokyosiRyakusyo  : array[0..7]   of Char;          //t
            Futan             : array[0..2]   of Char;          //Sd
            Koryu             : array[0..0]   of Char;          //𗬋敪
        end;

        crlf          : array[0..1] of Char;                    //R[h

    end;


    //****** QD[Xڍ ****************************************

    JV_RA_RACE = record
        head                  : _RECORD_ID;                     //<R[hwb_[>
        id                    : _RACE_ID;                       //<ʏP>
        RaceInfo              : _RACE_INFO;                     //<[X>
        GradeCD               : array[0..0] of Char;            //O[hR[h
        GradeCDBefore         : array[0..0] of Char;            //ύXOO[hR[h
        JyokenInfo            : _RACE_JYOKEN;                   //<R[h>
        JyokenName            : array[0..59]of Char;            //
        Kyori                 : array[0..3] of Char;            //
        KyoriBefore           : array[0..3] of Char;            //ύXO
        TrackCD               : array[0..1] of Char;            //gbNR[h
        TrackCDBefore         : array[0..1] of Char;            //ύXOgbNR[h
        CourseKubunCD         : array[0..1] of Char;            //R[X敪
        CourseKubunCDBefore   : array[0..1] of Char;            //ύXOR[X敪
        Honsyokin             : array[0..6,0..7] of Char;       //{܋
        HonsyokinBefore       : array[0..4,0..7] of Char;       //ύXO{܋
        Fukasyokin            : array[0..4,0..7] of Char;       //t܋
        FukasyokinBefore      : array[0..2,0..7] of Char;       //ύXOt܋
        HassoTime             : array[0..3] of Char;            //
        HassoTimeBefore       : array[0..3] of Char;            //ύXO
        TorokuTosu            : array[0..1] of Char;            //o^
        SyussoTosu            : array[0..1] of Char;            //o
        NyusenTosu            : array[0..1] of Char;            //
        TenkoBaba             :_TENKO_BABA_INFO;                //VEnԃR[h
        LapTime               : array[0..24,0..2] of Char;      //bv^C
        SyogaiMileTime        : array[0..3] of Char;            //Q}C^C
        HaronTimeS3           : array[0..2] of Char;            //ORn^C
        HaronTimeS4           : array[0..2] of Char;            //OSn^C
        HaronTimeL3           : array[0..2] of Char;            //Rn^C
        HaronTimeL4           : array[0..2] of Char;            //Sn^C

        CornerInfo : array[0..3] of record                      //<R[i[ʉߏ>
            Corner            : array[0..0] of Char;            //R[i[
            Syukaisu          : array[0..0] of Char;            //
            Jyuni             : array[0..69] of Char;           //eʉߏ
        end;

        RecordUpKubun         : array[0..0] of Char;            //R[hXV敪
        crlf                  : array[0..1] of Char;            //R[h؂
    end;


    //****** RDn[X ****************************************

    JV_SE_RACE_UMA = record
        head         : _RECORD_ID;                              //<R[hwb_[>
        id           : _RACE_ID;                                //<ʏP>
        Wakuban      : array[0..0] of Char;                     //g
        Umaban       : array[0..1] of Char;                     //n
        KettoNum     : array[0..9] of Char;                     //o^ԍ
        Bamei        : array[0..35]of Char;                     //n
        UmaKigoCD    : array[0..1] of Char;                     //nLR[h
        SexCD        : array[0..0] of Char;                     //ʃR[h
        HinsyuCD     : array[0..0] of Char;                     //iR[h
        KeiroCD      : array[0..1] of Char;                     //ѐFR[h
        Barei        : array[0..1] of Char;                     //n
        TozaiCD      : array[0..0] of Char;                     //R[h
        ChokyosiCode : array[0..4] of Char;                     //tR[h
        ChokyosiRyakusyo : array[0..7] of Char;                 //t
        BanusiCode   : array[0..5] of Char;                     //nR[h
        BanusiName   : array[0..63] of Char;                    //n喼
        Fukusyoku    : array[0..59] of Char;                    //FW
        reserved1    : array[0..59] of Char;                    //\
        Futan        : array[0..2] of Char;                     //Sd
        FutanBefore  : array[0..2] of Char;                     //ύXOSd
        Blinker      : array[0..0] of Char;                     //uJ[gp敪
        reserved2    : array[0..0] of Char;                     //\
        KisyuCode    : array[0..4] of Char;                     //RR[h
        KisyuCodeBefore : array[0..4] of Char;                  //ύXORR[h
        KisyuRyakusyo : array[0..7] of Char;                    //R薼
        KisyuRyakusyoBefore : array[0..7] of Char;              //ύXOR薼
        MinaraiCD    : array[0..0] of Char;                     //R茩KR[h
        MinaraiCDBefore : array[0..0] of Char;                  //ύXOR茩KR[h
        BaTaijyu     : array[0..2] of Char;                     //n̏d
        ZogenFugo    : array[0..0] of Char;                     //
        ZogenSa      : array[0..2] of Char;                     //
        IJyoCD       : array[0..0] of Char;                     //ُ敪R[h
        NyusenJyuni  : array[0..1] of Char;                     //
        KakuteiJyuni : array[0..1] of Char;                     //m蒅
        DochakuKubun : array[0..0] of Char;                     //敪
        DochakuTosu  : array[0..0] of Char;                     //
        Time         : array[0..3] of Char;                     //j^C
        ChakusaCD    : array[0..2] of Char;                     //R[h
        ChakusaCDP   : array[0..2] of Char;                     //+R[h
        ChakusaCDPP  : array[0..2] of Char;                     //++R[h
        Jyuni1c      : array[0..1] of Char;                     //1R[i[ł̏
        Jyuni2c      : array[0..1] of Char;                     //2R[i[ł̏
        Jyuni3c      : array[0..1] of Char;                     //3R[i[ł̏
        Jyuni4c      : array[0..1] of Char;                     //4R[i[ł̏
        Odds         : array[0..3] of Char;                     //PIbY
        Ninki        : array[0..1] of Char;                     //PlC
        Honsyokin    : array[0..7] of Char;                     //l{܋
        Fukasyokin   : array[0..7] of Char;                     //lt܋
        reserved3    : array[0..2] of Char;                     //\
        reserved4    : array[0..2] of Char;                     //\
        HaronTimeL4  : array[0..2] of Char;                     //Sn^C
        HaronTimeL3  : array[0..2] of Char;                     //Rn^C
        
        ChakuUmaInfo : array[0..2] of record                    //<1n(n)>
            KettoNum : array[0..9]  of Char;                    //o^ԍ
            Bamei    : array[0..35] of Char;                    //n
        end;
        
        TimeDiff     : array[0..3] of Char;                     //^C
        RecordUpKubun : array[0..0] of Char;                    //R[hXV敪
        DMKubun      : array[0..0] of Char;                     //}CjO敪
        DMTime       : array[0..4] of Char;                     //}CjO\zj^C
        DMGosaP      : array[0..3] of Char;                     //\덷(Mx){
        DMGosaM      : array[0..3] of Char;                     //\덷(Mx)|
        DMJyuni      : array[0..1] of Char;                     //}CjO\z
        KyakusituKubun : array[0..0] of Char;                   //񃌁[Xr
        crlf         : array[0..1] of Char;                     //R[h؂
        end;


    //****** SD ****************************************

    //<ߏP PEEg>
    _PAY_INFO1 = record
        Umaban      : array[0..1] of Char;                      //n
        Pay         : array[0..8] of Char;                      //ߋ
        Ninki       : array[0..1] of Char;                      //lC 
    end;

    //<ߏQ nAEChE\EnP>
    _PAY_INFO2 = record
        Kumi        : array[0..3] of Char;                      //g
        Pay         : array[0..8] of Char;                      //ߋ
        Ninki       : array[0..2] of Char;                      //lC
    end;


    //<ߏR RA>
    _PAY_INFO3 = record
        Kumi        : array[0..5] of Char;                      //g
        Pay         : array[0..8] of Char;                      //ߋ
        Ninki       : array[0..2] of Char;                      //lC 
    end;


    //<ߏS RAP>
    _PAY_INFO4 = record
        Kumi        : array[0..5] of Char;                      //g
        Pay         : array[0..8] of Char;                      //ߋ
        Ninki       : array[0..3] of Char;                      //lC
    end;

    JV_HR_PAY = record
        head             : _RECORD_ID;                          //<R[hwb_[>
        id               : _RACE_ID;                            //<ʏP>
        TorokuTosu       : array[0..1] of Char;                 //o^
        SyussoTosu       : array[0..1] of Char;                 //o
        FuseirituFlag    : array[0..8,0..0] of Char;            //stO
        TokubaraiFlag    : array[0..8,0..0] of Char;            //tO
        HenkanFlag       : array[0..8,0..0] of Char;            //Ԋ҃tO
        HenkanUma        : array[0..27,0..0] of Char;           //ԊҔnԏ(n01`28)
        HenkanWaku       : array[0..7,0..0] of Char;            //ԊҘgԏ(g1`8)
        HenkanDoWaku     : array[0..7,0..0] of Char;            //Ԋғg(g1`8)
        
        PayTansyo        : array[0..2] of _PAY_INFO1;           //<P>
        PayFukusyo       : array[0..4] of _PAY_INFO1;           //<>
        PayWakuren       : array[0..2] of _PAY_INFO1;           //<gA>
        PayUmaren        : array[0..2] of _PAY_INFO2;           //<nA>
        PayWide          : array[0..6] of _PAY_INFO2;           //<Ch>
        PayReserved1     : array[0..2] of _PAY_INFO2;           //<\>
        PayUmatan        : array[0..5] of _PAY_INFO2;           //<nP>
        PaySanrenpuku    : array[0..2] of _PAY_INFO3;           //<3A>
        PaySanrentan     : array[0..5] of _PAY_INFO4;           //<3AP>
        crlf             : array[0..1] of Char;                 //R[h؂
    end;


    //****** TD[iS|j****************************************

    //<[P PEEg>
    _HYO_INFO1 = record
        Umaban           : array[0..1] of Char;                 //n
        Hyo              : array[0..10] of Char;                //[
        Ninki            : array[0..1] of Char;                 //lC
    end;


    //<[Q nAEChEnP>
    _HYO_INFO2 = record
        Kumi             : array[0..3] of Char;                 //g
        Hyo              : array[0..10] of Char;                //[
        Ninki            : array[0..2] of Char;                 //lC
    end;


    //<[R RA[>
    _HYO_INFO3 = record
        Kumi             : array[0..5] of Char;                 //g
        Hyo              : array[0..10] of Char;                //[
        Ninki            : array[0..2] of Char;                 //lC
    end;



    JV_H1_HYOSU_ZENKAKE = record
        head :_RECORD_ID;                                       //<R[hwb_[>
        id : _RACE_ID;                                          //<ʏP>
        TorokuTosu        : array[0..1] of Char;                //o^
        SyussoTosu        : array[0..1] of Char;                //o
        HatubaiFlag       : array[0..6,0..0] of Char;           //tO
        FukuChakuBaraiKey : array[0..0] of Char;                //L[
        HenkanUma         : array[0..27,0..0] of Char;          //ԊҔnԏ(n01`28)
        HenkanWaku        : array[0..7,0..0] of Char;           //ԊҘgԏ(g1`8)
        HenkanDoWaku      : array[0..7,0..0] of Char;           //Ԋғg(g1`8)
        HyoTansyo         : array[0..27] of _HYO_INFO1;         //<P[>
        HyoFukusyo        : array[0..27] of _HYO_INFO1;         //<[>
        HyoWakuren        : array[0..35] of _HYO_INFO1;         //<gA[>
        HyoUmaren         : array[0..152] of _HYO_INFO2;        //<nA[>
        HyoWide           : array[0..152] of _HYO_INFO2;        //<Ch[>
        HyoUmatan         : array[0..305] of _HYO_INFO2;        //<nP[>
        HyoSanrenpuku     : array[0..815] of _HYO_INFO3;        //<3A[>
        HyoTotal          : array[0..13,0..10] of Char;         //[v
        crlf              : array[0..1] of Char;                //R[h؂
    end;


    //****** TD[iS|j****************************************

    //<[U RAP[>
    _HYO_INFO4 = record
        Kumi             : array[0..5] of Char;                 //g
        Hyo              : array[0..10] of Char;                //[
        Ninki            : array[0..3] of Char;                 //lC
    end;


    JV_H6_HYOSU_SANRENTAN = record
        head :_RECORD_ID;                                       //<R[hwb_[>
        id : _RACE_ID;                                          //<ʏP>
        TorokuTosu        : array[0..1] of Char;                //o^
        SyussoTosu        : array[0..1] of Char;                //o
        HatubaiFlag       : array[0..0] of Char;           //tO
        HenkanUma         : array[0..17,0..0] of Char;          //ԊҔnԏ(n01`28)
        HyoSanrentan      : array[0..4895] of _HYO_INFO4;        //<3A[>
        HyoTotal          : array[0..1,0..10] of Char;         //[v
        crlf              : array[0..1] of Char;                //R[h؂
    end;



    //****** UDIbYiPgj****************************************

    JV_O1_ODDS_TANFUKUWAKU = record
        head              : _RECORD_ID;                        //<R[hwb_[>
        id                : _RACE_ID;                          //<ʏP>
        HappyoTime        : _MDHM;                             //\
        TorokuTosu        : array[0..1] of Char;               //o^
        SyussoTosu        : array[0..1] of Char;               //o
        TansyoFlag        : array[0..0] of Char;               //tO P
        FukusyoFlag       : array[0..0] of Char;               //tO 
        WakurenFlag       : array[0..0] of Char;               //tO@gA
        FukuChakuBaraiKey : array[0..0] of Char;               //L[
        
        OddsTansyoInfo : array[0..27] of record                //<PIbY>
            Umaban        : array[0..1]  of Char;              //n
            Odds          : array[0..3]  of Char;              //IbY
            Ninki         : array[0..1]  of Char;              //lC
        end;
        
        OddsFukusyoInfo : array[0..27] of record               //<[IbY>
            Umaban        : array[0..1]  of Char;              //n
            OddsLow       : array[0..3]  of Char;              //ŒIbY
            OddsHigh      : array[0..3]  of Char;              //ōIbY
            Ninki         : array[0..1]  of Char;              //lC
        end;
        
        OddsWakurenInfo : array[0..35] of record               //<gA[IbY>
            Kumi          : array[0..1]  of Char;              //g
            Odds          : array[0..4]  of Char;              //IbY
            Ninki         : array[0..1]  of Char;              //lC
        end;

        TotalHyosuTansyo  : array[0..10] of Char;              //P[v
        TotalHyosuFukusyo : array[0..10] of Char;              //[v
        TotalHyosuWakuren : array[0..10] of Char;              //gA[v
        crlf              : array[0..1]  of Char;              //R[h؂
    end;


    //****** VDIbYinAj****************************************

    JV_O2_ODDS_UMAREN = record
        head             : _RECORD_ID;                         //<R[hwb_[>
        id               : _RACE_ID;                           //<ʏP>
        HappyoTime       : _MDHM;                              //\
        TorokuTosu       : array[0..1] of Char;                //o^
        SyussoTosu       : array[0..1] of Char;                //o
        UmarenFlag       : array[0..0] of Char;                //tO@nA
        
        OddsUmarenInfo : array[0..152] of record               ///<nAIbY>
            Kumi         : array[0..3]  of Char;               //g
            Odds         : array[0..5]  of Char;               //IbY
            Ninki        : array[0..2]  of Char;               //lC
        end;

        TotalHyosuUmaren : array[0..10] of Char;               //nA[v
        crlf             : array[0..1]  of Char;               //R[h؂
    end;


    //****** WDIbYiChj****************************************
   
    JV_O3_ODDS_WIDE = record
        head           : _RECORD_ID;                          //<R[hwb_[>
        id             : _RACE_ID;                            //<ʏP>
        HappyoTime     : _MDHM;                               //\
        TorokuTosu     : array[0..1]   of Char;               //o^
        SyussoTosu     : array[0..1]   of Char;               //o
        WideFlag       : array[0..0]   of Char;               //tO@Ch
        
        OddsWideInfo : array[0..152] of record                //<ChIbY>
            Kumi       : array[0..3]   of Char;               //g
            OddsLow    : array[0..4]   of Char;               //ŒIbY
            OddsHigh   : array[0..4]   of Char;               //ōIbY
            Ninki      : array[0..2]   of Char;               //lC
        end;
    
        TotalHyosuWide : array[0..10]  of Char;               //Ch[v
         crlf          : array[0..1]   of Char;               //R[h؂
    end;


    //****** XDIbYinPj ****************************************

    JV_O4_ODDS_UMATAN = record
        head              : _RECORD_ID;                       //<R[hwb_[>
        id                : _RACE_ID;                         //<ʏP>
        HappyoTime        : _MDHM;                            //\
        TorokuTosu        : array[0..1]   of Char;            //o^
        SyussoTosu        : array[0..1]   of Char;            //o
        UmatanFlag        : array[0..0]   of Char;            //tO@nP

        OddsUmatanInfo : array[0..305] of record              //<nPIbY>
            Kumi          : array[0..3]   of Char;            //g
            Odds          : array[0..5]   of Char;            //IbY
            Ninki         : array[0..2]   of Char;            //lC
        end;
    
        TotalHyosuUmatan  : array[0..10] of Char;             //nP[v
        crlf              : array[0..1]  of Char;             //R[h؂
    end;


    //****** PODIbYiRAj****************************************
   
    JV_O5_ODDS_SANREN = record
        head           : _RECORD_ID;                         //<R[hwb_[>
        id             : _RACE_ID;                           //<ʏP>
        HappyoTime     : _MDHM;                              //\
        TorokuTosu     : array[0..1] of Char;                //o^
        SyussoTosu     : array[0..1] of Char;                //o
        SanrenpukuFlag : array[0..0] of Char;                //tO@3A
        
        OddsSanrenInfo : array[0..815] of record             //<3AIbY>
            Kumi  : array[0..5] of Char;                     //g
            Odds  : array[0..5] of Char;                     //IbY
            Ninki : array[0..2] of Char;                     //lC
        end;

        TotalHyosuSanrenpuku : array[0..10] of Char;         //3A[v
        crlf : array[0..1] of Char;                          //R[h؂
    end;
    
    //****** PPDIbYiRAPj****************************************
   
    JV_O6_ODDS_SANRENTAN = record
        head           : _RECORD_ID;                         //<R[hwb_[>
        id             : _RACE_ID;                           //<ʏP>
        HappyoTime     : _MDHM;                              //\
        TorokuTosu     : array[0..1] of Char;                //o^
        SyussoTosu     : array[0..1] of Char;                //o
        SanrentanFlag : array[0..0] of Char;                //tO@3AP
        
        OddsSanrentanInfo : array[0..4895] of record         //<3APIbY>
            Kumi  : array[0..5] of Char;                     //g
            Odds  : array[0..6] of Char;                     //IbY
            Ninki : array[0..3] of Char;                     //lC
        end;

        TotalHyosuSanrentan : array[0..10] of Char;         //3A[v
        crlf : array[0..1] of Char;                          //R[h؂
    end;


    //****** PQDn}X^ ****************************************
  
    JV_UM_UMA = record
        head             : _RECORD_ID;                       //<R[hwb_[>
        KettoNum         : array[0..9]  of Char;             //o^ԍ
        DelKubun         : array[0..0]  of Char;             //n敪
        RegDate          : _YMD;                             //no^N
        DelDate          : _YMD;                             //nN
        BirthDate        : _YMD;                             //N
        Bamei            : array[0..35] of Char;             //n
        BameiKana        : array[0..35] of Char;             //npJi
        BameiEng         : array[0..59] of Char;             //n
        ZaikyuFlag       : array[0..0]  of Char;             //JRA{ݍ݂イtO
        Reserved         : array[0..18] of Char;             //\
        UmaKigoCD        : array[0..1]  of Char;             //nLR[h
        SexCD            : array[0..0]  of Char;             //ʃR[h
        HinsyuCD         : array[0..0]  of Char;             //iR[h
        KeiroCD          : array[0..1]  of Char;             //ѐFR[h
        
        Ketto3Info       : array[0..13] of record            //<3㌌>
            HansyokuNum  : array[0..9]  of Char;             //ɐBo^ԍ
            Bamei        : array[0..35] of Char;             //n
        end;
        
        TozaiCD          : array[0..0]  of Char;             //R[h
        ChokyosiCode     : array[0..4]  of Char;             //tR[h
        ChokyosiRyakusyo : array[0..7]  of Char;             //t
        Syotai           : array[0..19] of Char;             //Ғn於
        BreederCode      : array[0..7]  of Char;             //Y҃R[h
        BreederName      : array[0..71] of Char;             //YҖ
        SanchiName       : array[0..19] of Char;             //Yn
        BanusiCode       : array[0..5]  of Char;             //nR[h
        BanusiName       : array[0..63] of Char;             //n喼
        RuikeiHonsyoHeiti  : array[0..8]  of Char;           //n{܋݌v
        RuikeiHonsyoSyogai : array[0..8]  of Char;           //Q{܋݌v
        RuikeiFukaHeichi : array[0..8]    of Char;           //nt܋݌v
        RuikeiFukaSyogai : array[0..8]    of Char;           //Qt܋݌v
        RuikeiSyutokuHeichi : array[0..8] of Char;           //n܋݌v
        RuikeiSyutokuSyogai : array[0..8] of Char;           //Q܋݌v
        ChakuSogo        : _CHAKUKAISU3_INFO;               //
        ChakuChuo        : _CHAKUKAISU3_INFO;               //v
        ChakuKaisuBa     : array[0..6]    of _CHAKUKAISU3_INFO;   //nʒ
        ChakuKaisuJyotai : array[0..11]   of _CHAKUKAISU3_INFO;   //nԕʒ
        ChakuKaisuKyori  : array[0..5]    of _CHAKUKAISU3_INFO;   //ʒ
        Kyakusitu        : array[0..3,0..2]    of Char;      //rX
        RaceCount        : array[0..2]    of Char;           //o^[X
        crlf             : array[0..1]    of Char;           //R[h؂
    end;


    //****** PRDR}X^ ****************************************

    JV_KS_KISYU = record
        head                 :_RECORD_ID;                    //<R[hwb_[>
        KisyuCode            : array[0..4]  of Char;         //RR[h
        DelKubun             : array[0..0]  of Char;         //R薕敪
        IssueDate            : _YMD;                         //RƋtN
        DelDate              : _YMD;                         //RƋN
        BirthDate            : _YMD;                         //N
        KisyuName            : array[0..33] of Char;         //R薼
        reserved             : array[0..33] of Char;         //\
        KisyuNameKana        : array[0..29] of Char;         //R薼pJi
        KisyuRyakusyo        : array[0..7]  of Char;         //R薼
        KisyuNameEng         : array[0..79] of Char;         //R薼
        SexCD                : array[0..0]  of Char;         //ʋ敪
        SikakuCD             : array[0..0]  of Char;         //R掑iR[h
        MinaraiCD            : array[0..0]  of Char;         //R茩KR[h
        TozaiCD              : array[0..0]  of Char;         //R蓌R[h
        Syotai               : array[0..19] of Char;         //Ғn於
        ChokyosiCode         : array[0..4]  of Char;         //tR[h
        ChokyosiRyakusyo     : array[0..7]  of Char;         //t

        HatuKiJyo            : array[0..1]  of record        //<R>
            Hatukijyoid      : _RACE_ID;                     //NR
            SyussoTosu       : array[0..1]  of Char;         //o
            KettoNum         : array[0..9]  of Char;         //o^ԍ
            Bamei            : array[0..35] of Char;         //n
            KakuteiJyuni     : array[0..1]  of Char;         //m蒅
            IJyoCD           : array[0..0]  of Char;         //ُ敪R[h
        end;

        HatuSyori            : array[0..1]  of record        //<>
            Hatusyoriid      : _RACE_ID;                     //NR
            SyussoTosu       : array[0..1]  of Char;         //o
            KettoNum         : array[0..9]  of Char;         //o^ԍ
            Bamei            : array[0..35] of Char;         //n
        end;

        SaikinJyusyo         : array[0..2]  of _SAIKIN_JYUSYO_INFO;     //<ŋߏd܏>
        HonZenRuikei         : array[0..2]  of _HON_ZEN_RUIKEISEI_INFO; //<{NEONE݌vя>
        crlf                 : array[0..1]  of Char;                    //R[h؂
    end;


    //****** PSDt}X^ ****************************************

    JV_CH_CHOKYOSI = record
        head            : _RECORD_ID;                         //<R[hwb_[>
        ChokyosiCode    : array[0..4] of Char;                //tR[h
        DelKubun        : array[0..0] of Char;                //t敪
        IssueDate       : _YMD;                //tƋtN
        DelDate         : _YMD;                //tƋN
        BirthDate       : _YMD;                //N
        ChokyosiName    : array[0..33] of Char;               //t
        ChokyosiNameKana : array[0..29] of Char;              //tpJi
        ChokyosiRyakusyo : array[0..7] of Char;               //t
        ChokyosiNameEng : array[0..79] of Char;               //t
        SexCD           : array[0..0] of Char;                //ʋ敪
        TozaiCD         : array[0..0] of Char;                //tR[h
        Syotai          : array[0..19] of Char;               //Ғn於
        SaikinJyusyo    : array[0..2] of _SAIKIN_JYUSYO_INFO;     //<ŋߏd܏>
        HonZenRuikei    : array[0..2] of _HON_ZEN_RUIKEISEI_INFO; //<{NEONE݌vя>
        crlf            : array[0..1] of Char;                //R[h؂
    end;


    //******PTDY҃}X^ ****************************************

    JV_BR_BREEDER = record
        head            :_RECORD_ID;                          //<R[hwb_[>
        BreederCode     : array[0..7]   of Char;              //Y҃R[h
        BreederName_Co  : array[0..71] of Char;               //YҖ(@liL)
        BreederName     : array[0..71] of Char;               //YҖ(@li)
        BreederNameKana : array[0..71]  of Char;              //YҖpJi
        BreederNameEng  : array[0..167] of Char;              //YҖ
        Address         : array[0..19]   of Char;             //YҏZȖ
        HonRuikei       : array[0..1]   of _SEI_RUIKEI_INFO;  //<{NE݌vя>
        crlf            : array[0..1]   of Char;              //R[h؂
    end;


    //****** PUDn}X^ ****************************************

    JV_BN_BANUSI = record
        head :_RECORD_ID;                                     //<R[hwb_[>
        BanusiCode     : array[0..5]  of Char;                //nR[h
        BanusiName_Co  : array[0..63] of Char;                //n喼(@liL)
        BanusiName     : array[0..63] of Char;                //n喼(@li)
        BanusiNameKana : array[0..49] of Char;                //n喼pJi
        BanusiNameEng  : array[0..99] of Char;                //n喼
        Fukusyoku      : array[0..59] of Char;                //FW
        HonRuikei      : array[0..1]  of _SEI_RUIKEI_INFO;    //<{NE݌vя>
        crlf           : array[0..1]  of Char;                //R[h؂
    end;


    //****** PVDɐBn}X^ ****************************************

    JV_HN_HANSYOKU = record
        head        : _RECORD_ID;                             //<R[hwb_[>
        HansyokuNum : array[0..9] of Char;                    //ɐBo^ԍ
        reserved    : array[0..7] of Char;                    //\
        KettoNum    : array[0..9] of Char;                    //o^ԍ
        DelKubun    : array[0..0] of Char;                    //ɐBn敪(݂͗\ƂĎgp)
        Bamei       : array[0..35] of Char;                   //n
        BameiKana   : array[0..39] of Char;                   //npJi
        BameiEng    : array[0..79] of Char;                   //n
        BirthYear   : array[0..3] of Char;                    //N
        SexCD       : array[0..0] of Char;                    //ʃR[h
        HinsyuCD    : array[0..0] of Char;                    //iR[h
        KeiroCD     : array[0..1] of Char;                    //ѐFR[h
        HansyokuMochiKubun : array[0..0] of Char;             //ɐBn敪
        ImportYear  : array[0..3] of Char;                    //AN
        SanchiName  : array[0..19] of Char;                   //Yn
        HansyokuFNum : array[0..9] of Char;                   //nɐBo^ԍ
        HansyokuMNum : array[0..9] of Char;                   //nɐBo^ԍ
        crlf        : array[0..1] of Char;                    //R[h؂
    end;


    //****** PWDY}X^ ****************************************

    JV_SK_SANKU = record
        head            : _RECORD_ID;                         //<R[hwb_[>
        KettoNum        : array[0..9] of Char;                //o^ԍ
        BirthDate       : _YMD;                               //N
        SexCD           : array[0..0] of Char;                //ʃR[h
        HinsyuCD        : array[0..0] of Char;                //iR[h
        KeiroCD         : array[0..1] of Char;                //ѐFR[h
        SankuMochiKubun : array[0..0] of Char;                //Y敪
        ImportYear      : array[0..3] of Char;                //AN
        BreederCode     : array[0..7] of Char;                //Y҃R[h
        SanchiName      : array[0..19] of Char;               //Yn
        HansyokuNum     : array[0..13,0..9] of Char;          //3㌌ ɐBo^ԍ
        crlf            : array[0..1] of Char;                //R[h؂
    end;


    //****** PXDR[h}X^ ****************************************
    
    JV_RC_RECORD = record
        head             : _RECORD_ID;                        //<R[hwb_[>
        RecInfoKubun     : array[0..0] of Char;               //R[hʋ敪
        id               : _RACE_ID;                          //<ʏP>
        TokuNum          : array[0..3] of Char;               //ʋԍ
        Hondai           : array[0..59] of Char;              //{
        GradeCD          : array[0..0] of Char;               //O[hR[h
        SyubetuCD        : array[0..1] of Char;               //ʃR[h
        Kyori            : array[0..3] of Char;               //
        TrackCD          : array[0..1] of Char;               //gbNR[h
        RecKubun         : array[0..0] of Char;               //R[h敪
        RecTime          : array[0..3] of Char;               //R[h^C
        TenkoBaba        : _TENKO_BABA_INFO;                  //VEn

        RecUmaInfo : array[0..2] of record                    //<R[hێn>
            KettoNum     : array[0..9]  of Char;              //o^ԍ
            Bamei        : array[0..35] of Char;              //n
            UmaKigoCD    : array[0..1]  of Char;              //nLR[h
            SexCD        : array[0..0]  of Char;              //ʃR[h
            ChokyosiCode : array[0..4]  of Char;              //tR[h
            ChokyosiName : array[0..33] of Char;              //t
            Futan        : array[0..2]  of Char;              //Sd
            KisyuCode    : array[0..4]  of Char;              //RR[h
            KisyuName    : array[0..33] of Char;              //R薼
        end;

        crlf            : array[0..1] of Char;                //R[h؂
    end;


    //****** QODH ****************************************

    JV_HC_HANRO = record
        head        : _RECORD_ID;                             //<R[hwb_[>
        TresenKubun : array[0..0] of Char;                    //gZ敪
        ChokyoDate  : _YMD;                                   //N
        ChokyoTime  : array[0..3] of Char;                    //
        KettoNum    : array[0..9] of Char;                    //o^ԍ
        HaronTime4  : array[0..3] of Char;                    //4n^Cv(800M-0M)
        LapTime4    : array[0..2] of Char;                    //bv^C(800M-600M)
        HaronTime3  : array[0..3] of Char;                    //3n^Cv(600M-0M)
        LapTime3    : array[0..2] of Char;                    //bv^C(600M-400M)
        HaronTime2  : array[0..3] of Char;                    //2n^Cv(400M-0M)
        LapTime2    : array[0..2] of Char;                    //bv^C(400M-200M)
        LapTime1    : array[0..2] of Char;                    //bv^C(200M-0M)
        crlf        : array[0..1] of Char;                    //R[h؂
    end;


    //****** QODn̏d ****************************************
  
     JV_WH_BATAIJYU = record
        head               : _RECORD_ID;                      //<R[hwb_[>
        id                 : _RACE_ID;                        //<ʏP>
        HappyoTime         : _MDHM;                           //\

        BataijyuInfo : array[0..17] of record                 //<n̏d>
            Umaban         : array[0..1]  of Char;            //n
            Bamei          : array[0..35] of Char;            //n
            BaTaijyu       : array[0..2]  of Char;            //n̏d
            ZogenFugo      : array[0..0]  of Char;            //
            ZogenSa        : array[0..2]  of Char;            //
        end;

        crlf               : array[0..1] of Char;             //R[h؂
    end;


    //****** QPDVn ******************************************

    JV_WE_WEATHER = record
        head            : _RECORD_ID;                         //<R[hwb_[>
        id              : _RACE_ID2;                          //<ʏQ>
        HappyoTime      : _MDHM;                              //\
        HenkoID         : array[0..0] of Char;                //ύX
        TenkoBaba       : _TENKO_BABA_INFO;                   //ݏԏ
        TenkoBabaBefore : _TENKO_BABA_INFO;                   //ύXOԏ
        crlf            : array[0..1] of Char;                //R[h؂
    end;


    //****** QQDoEO ****************************************

     JV_AV_INFO = record 
        head        : _RECORD_ID;                             //<R[hwb_[>
        id          : _RACE_ID;                               //<ʏP>
        HappyoTime  : _MDHM;                                  //\
        Umaban      : array[0..1]  of Char;                   //n
        Bamei       : array[0..35] of Char;                   //n
        JiyuKubun   : array[0..2]  of Char;                   //R敪
        crlf        : array[0..1]  of Char;                   //R[h؂
    end;


    //************ QRDRύX ****************************************

     JV_JC_INFO = record                                      //<ύX>
        head          : _RECORD_ID;                           //<R[hwb_[>
        id            : _RACE_ID;                             //<ʏP>
        HappyoTime    : _MDHM;                                //\
        Umaban        : array[0..1]  of Char;                 //n
        Bamei         : array[0..35] of Char;                 //n
        JCInfoAfter   : _JC_INFO;                             //<ύX>
        JCInfoBefore  : _JC_INFO;                             //<ύXO>
        crlf          : array[0..1] of Char;                  //R[h؂
    end;

    //************ QRDύX ****************************************

     JV_TC_INFO = record                                      //<ύX>
        head          : _RECORD_ID;                           //<R[hwb_[>
        id            : _RACE_ID;                             //<ʏP>
        HappyoTime    : _MDHM;                                //\
        TCInfoAfter   : _TC_INFO;                             //ύX
        TCInfoBefore  : _TC_INFO;                             //ύXO
        crlf          : array[0..1] of Char;                  //R[h؂
    end;
    
    //************ QRDR[XύX ****************************************

     JV_CC_INFO = record                                      //<ύX>
        head          : _RECORD_ID;                           //<R[hwb_[>
        id            : _RACE_ID;                             //<ʏP>
        HappyoTime    : _MDHM;                                //\
        CCInfoAfter   : _CC_INFO;                             //<ύX>
        CCInfoBefore  : _CC_INFO;                             //<ύXO>
        JiyuKubun     : array[0..0]  of Char;                 //R敪
        crlf          : array[0..1] of Char;                  //R[h؂
    end;    
    //****** QSDf[^}CjO\z************************************

    JV_DM_INFO = record                                       //<}CjO\z>
        head         : _RECORD_ID;                            //<R[hwb_[>
        id           : _RACE_ID;                              //<ʏP>
        MakeHM       : _HM;                                   //f[^쐬

        DMInfo : array[0..17] of record                       //<}CjO\z>
            Umaban   : array[0..1]  of Char;                  //n
            DMTime   : array[0..4]  of Char;                  //\zj^C
            DMGosaP  : array[0..3]  of Char;                  //\z덷(Mx){
            DMGosaM  : array[0..3]  of Char;                  //\z덷(Mx)|
        end;

        crlf         : array[0..1]  of Char;                  //R[h؂
    end;


    //****** QTDJÃXPW[************************************

    JV_YS_SCHEDULE = record
        head         : _RECORD_ID;                           //<R[hwb_[>
        id           : _RACE_ID2;                            //<ʏQ>
        YoubiCD      : array[0..0] of Char;                  //jR[h

        JyusyoInfo : array[0..2] of record                   //<d܈ē>
            TokuNum  : array[0..3] of Char;                  //ʋԍ
            Hondai   : array[0..59] of Char;                 //{
            Ryakusyo10   : array[0..19] of Char;             //10
            Ryakusyo6    : array[0..11] of Char;             //6
            Ryakusyo3    : array[0..5] of Char;              //3
            Nkai         : array[0..2] of Char;              //d܉[N]
            GradeCD      : array[0..0] of Char;              //O[hR[h
            SyubetuCD    : array[0..1] of Char;              //ʃR[h
            KigoCD   : array[0..2] of Char;                  //LR[h
            JyuryoCD : array[0..0] of Char;                  //dʎʃR[h
            Kyori    : array[0..3] of Char;                  //
            TrackCD  : array[0..1] of Char;                  //gbNR[h
        end;
 
        crlf         : array[0..1] of Char;                  //R[h؂
     end;


    //****** QUDnsi ****************************************

    JV_HS_SALE = record
        head         : _RECORD_ID;                           //<R[hwb_[>
        KettoNum     : array[0..9] of Char;                  //o^ԍ
        HansyokuFNum : array[0..9] of Char;                  //nɐBo^ԍ
        HansyokuMNum : array[0..9] of Char;                  //nɐBo^ԍ
        BirthYear    : array[0..3] of Char;                  //N
        SaleCode     : array[0..5] of Char;                  //ÎҁEsR[h
        SaleHostName : array[0..39] of Char;                 //ÎҖ
        SaleName     : array[0..79] of Char;                 //s̖
        FromDate     : _YMD;                                 //s̊JÊ(Jn)
        ToDate       : _YMD;                                 //s̊JÊ(I)
        Barei        : array[0..0] of Char;                  //̋n̔N
        Price        : array[0..9] of Char;                  //i
        crlf         : array[0..0] of Char;                  //R[h؂
     end;

    //****** QVDn̈ӖR ****************************************

    JV_HY_BAMEIORIGIN = record
        head         : _RECORD_ID;                           //<R[hwb_[>
        KettoNum     : array[0..9] of Char;                  //o^ԍ
        Bamei        : array[0..35] of Char;                 //n
        Origin       : array[0..63] of Char;                 //n̈ӖR
        crlf         : array[0..0] of Char;                  //R[h؂
     end;

    //****** QWDoʒx ****************************************

    //<oʒx n>

    JV_CK_UMA = record
        KettoNum            : array[0..9] of Char;                   //o^ԍ
        Bamei               : array[0..35] of Char;                  //n
        RuikeiHonsyoHeiti   : array[0..8] of Char;                   //n{܋݌v
        RuikeiHonsyoSyogai  : array[0..8] of Char;                   //Q{܋݌v
        RuikeiFukaHeichi    : array[0..8] of Char;                   //nt܋݌v
        RuikeiFukaSyogai    : array[0..8] of Char;                   //Qt܋݌v
        RuikeiSyutokuHeichi : array[0..8] of Char;                   //n܋݌v
        RuikeiSyutokuSyogai : array[0..8] of Char;                   //Q܋݌v
        ChakuSogo           : _CHAKUKAISU3_INFO;                     //
        ChakuChuo           : _CHAKUKAISU3_INFO;                     //v
        ChakuKaisuBa        : array[0..6]    of _CHAKUKAISU3_INFO;   //nʒ
        ChakuKaisuJyotai    : array[0..11]   of _CHAKUKAISU3_INFO;   //nԕʒ
        ChakuKaisuSibaKyori : array[0..8]    of _CHAKUKAISU3_INFO;   //ŋʒ
        ChakuKaisuDirtKyori : array[0..8]    of _CHAKUKAISU3_INFO;   //_[gʒ
        ChakuKaisuJyoSiba   : array[0..9]    of _CHAKUKAISU3_INFO;   //nʎŒ
        ChakuKaisuJyoDirt   : array[0..9]    of _CHAKUKAISU3_INFO;   //nʃ_[g
        ChakuKaisuJyoSyogai : array[0..9]    of _CHAKUKAISU3_INFO;   //nʏQ
        Kyakusitu           : array[0..3,0..2]    of Char;           //rX
        RaceCount           : array[0..2]    of Char;                //o^[X
     end;

    //<oʒx {NE݌vя>

    _CK_HON_RUIKEISEI_INFO = record
        SetYear             : array[0..3] of Char;                   //ݒN
        HonSyokinHeichi     : array[0..9] of Char;                   //n{܋v
        HonSyokinSyogai     : array[0..9] of Char;                   //Q{܋v
        FukaSyokinHeichi    : array[0..9] of Char;                   //nt܋v
        FukaSyokinSyogai    : array[0..9] of Char;                   //Qt܋v
        ChakuKaisuSiba      : _CHAKUKAISU5_INFO;                     //Œ
        ChakuKaisuDirt      : _CHAKUKAISU5_INFO;                     //_[g
        ChakuKaisuSyogai    : _CHAKUKAISU4_INFO;                     //Q
        ChakuKaisuSibaKyori : array[0..8]    of _CHAKUKAISU4_INFO;   //ŋʒ
        ChakuKaisuDirtKyori : array[0..8]    of _CHAKUKAISU4_INFO;   //_[gʒ
        ChakuKaisuJyoSiba   : array[0..9]    of _CHAKUKAISU4_INFO;   //nʎŒ
        ChakuKaisuJyoDirt   : array[0..9]    of _CHAKUKAISU4_INFO;   //nʃ_[g
        ChakuKaisuJyoSyogai : array[0..9]    of _CHAKUKAISU3_INFO;   //nʏQ
    end;

    //<oʒx R>

    JV_CK_KISYU = record
        KisyuCode            : array[0..4]  of Char;                  //RR[h
        KisyuName            : array[0..33] of Char;                  //R薼
        HonRuikei            : array[0..1]  of _CK_HON_RUIKEISEI_INFO //<{NE݌vя>
    end;

    //<oʒx t>

    JV_CK_CHOKYOSI = record
        ChokyosiCode      : array[0..4]  of Char;                  //tR[h
        ChokyosiName      : array[0..33] of Char;                  //t
        HonRuikei         : array[0..1]  of _CK_HON_RUIKEISEI_INFO //<{NE݌vя>
    end;

    //<oʒx n>

    JV_CK_BANUSI = record
        BanusiCode     : array[0..5]  of Char;                //nR[h
        BanusiName_Co  : array[0..63] of Char;                //n喼(@liL)
        BanusiName     : array[0..63] of Char;                //n喼(@li)
        HonRuikei      : array[0..1]  of _SEI_RUIKEI_INFO;    //<{NE݌vя>
    end;

    //<oʒx Yҏ>

    JV_CK_BREEDER = record
        BreederCode     : array[0..7]  of Char;               //Y҃R[h
        BreederName_Co  : array[0..71] of Char;               //YҖ(@liL)
        BreederName     : array[0..71] of Char;               //YҖ(@li)
        HonRuikei       : array[0..1]  of _SEI_RUIKEI_INFO;   //<{NE݌vя>
    end;

    // oʒx

    JV_CK_CHAKU = record
        head            : _RECORD_ID;                         //<R[hwb_[>
        id              : _RACE_ID;                           //<ʏP>
        UmaChaku        : JV_CK_UMA;                          //<oʒx n>
        KisyuChaku      : JV_CK_KISYU;                        //<oʒx R>
        ChokyoChaku     : JV_CK_CHOKYOSI;                     //<oʒx t>
        BanusiChaku     : JV_CK_BANUSI;                       //<oʒx n>
        BreederChaku    : JV_CK_BREEDER;                      //<oʒx Yҏ>
        crlf            : array[0..1]   of Char;              //R[h؂
    end;

    //****** QXDn ********************************************
    
    JV_BT_KEITO = record
        head         : _RECORD_ID;                           //<R[hwb_[>
        HansyokuNum  : array[0..9] of Char;                  //ɐBo^ԍ
        KeitoId      : array[0..29] of Char;                 //nID
        KeitoName    : array[0..35] of Char;                 //n
        KeitoEx      : array[0..6799] of Char;               //n
        crlf         : array[0..1] of Char;                  //R[h؂
     end;

    //****** RODR[X ******************************************
    
    JV_CS_COURSE = record
        head         : _RECORD_ID;                           //<R[hwb_[>
        JyoCd        : array[0..1] of Char;                  //nR[h
        Kyori        : array[0..3] of Char;                  //
        TrackCD      : array[0..1] of Char;                  //gbNR[h
        KaishuDate   : _YMD;                                 //R[XCN
        CourseEx     : array[0..6799] of Char;               //R[X
        crlf         : array[0..1] of Char;                  //R[h؂
     end;

    //****** RPDΐ^f[^}CjO\z************************************

    JV_TM_INFO = record
        head         : _RECORD_ID;                            //<R[hwb_[>
        id           : _RACE_ID;                              //<ʏP>
        MakeHM       : _HM;                                   //f[^쐬

        TMInfo : array[0..17] of record                       //<}CjO\z>
            Umaban   : array[0..1]  of Char;                  //n
            TMScore  : array[0..3]  of Char;                  //\XRA
        end;

        crlf         : array[0..1]  of Char;                  //R[h؂
    end;

    //****** RQDd(WIN5)************************************

    JV_WF_INFO = record
        head             : _RECORD_ID;                       //<R[hwb_[>
        KaisaiDate       : _YMD;                             //<JÔN>
        reserved1        : array[0..1] of Char;              //\

        WFRaceInfo : array[0..4] of record                   //<dΏۃ[X>
            JyoCD        : array[0..1] of Char;              //nR[h
            Kaiji        : array[0..1] of Char;              //JÉ[N]
            Nichiji      : array[0..1] of Char;              //JÓ[N]
            RaceNum      : array[0..1] of Char;              //[Xԍ
        end;

        reserved2        : array[0..5] of Char;              //\
        Hatsubai_Hyo     : array[0..10] of Char;             //d[

        WFYukoHyoInfo : array[0..4] of record                //<L[>
            Yuko_Hyo     : array[0..10] of Char;             //L[
        end;

        HenkanFlag       : array[0..0] of Char;              //Ԋ҃tO
        FuseiritsuFlag   : array[0..0] of Char;              //stO
        TekichunashiFlag : array[0..0] of Char;              //ItO
        COShoki          : array[0..14] of Char;             //L[I[o[z
        COZanDaka        : array[0..14] of Char;             //L[I[o[zc

        WFPayInfo : array[0..242] of record                  //<dߏ>
            Kumiban      : array[0..9] of Char;              //g
            Pay          : array[0..8] of Char;              //dߋ
            Tekichu_Hyo  : array[0..9] of Char;              //I[
        end;

        crlf         : array[0..1]  of Char;                 //R[h؂
    end;

    //****** RRDnO************************************

    JV_JG_JOGAIBA = record
        head             : _RECORD_ID;                       //<R[hwb_[>
        id               : _RACE_ID;                         //<ʏP>
        KettoNum         : array[0..9] of Char;              //o^ԍ
        Bamei            : array[0..35] of Char;             //n
        ShutsubaTohyoJun : array[0..2] of Char;              //on[t
        ShussoKubun      : array[0..0] of Char;              //o敪
        JogaiJotaiKubun  : array[0..0] of Char;              //Oԋ敪

        crlf             : array[0..1]  of Char;             //R[h؂
    end;

    //****** RSDEbh`bv ****************************************

    JV_WC_WOOD = record
        head        : _RECORD_ID;                             //<R[hwb_[>
        TresenKubun : array[0..0] of Char;                    //gZ敪
        ChokyoDate  : _YMD;                                   //N
        ChokyoTime  : array[0..3] of Char;                    //
        KettoNum    : array[0..9] of Char;                    //o^ԍ
        Course      : array[0..0] of Char;                    //R[X
        BabaAround  : array[0..0] of Char;                    //n
        reserved    : array[0..0] of Char;                    //\
        HaronTime10 : array[0..3] of Char;                    //10n^Cv(2000M-0M)
        LapTime10   : array[0..2] of Char;                    //bv^C(2000M-1800M)
        HaronTime9  : array[0..3] of Char;                    //9n^Cv(1800M-0M)
        LapTime9    : array[0..2] of Char;                    //bv^C(1800M-1600M)
        HaronTime8  : array[0..3] of Char;                    //8n^Cv(1600M-0M)
        LapTime8    : array[0..2] of Char;                    //bv^C(1600M-1400M)
        HaronTime7  : array[0..3] of Char;                    //7n^Cv(1400M-0M)
        LapTime7    : array[0..2] of Char;                    //bv^C(1400M-1200M)
        HaronTime6  : array[0..3] of Char;                    //6n^Cv(1200M-0M)
        LapTime6    : array[0..2] of Char;                    //bv^C(1200M-1000M)     
        HaronTime5  : array[0..3] of Char;                    //5n^Cv(1000M-0M)
        LapTime5    : array[0..2] of Char;                    //bv^C(1000M-800M)
        HaronTime4  : array[0..3] of Char;                    //4n^Cv(800M-0M)
        LapTime4    : array[0..2] of Char;                    //bv^C(800M-600M)
        HaronTime3  : array[0..3] of Char;                    //3n^Cv(600M-0M)
        LapTime3    : array[0..2] of Char;                    //bv^C(600M-400M)
        HaronTime2  : array[0..3] of Char;                    //2n^Cv(400M-0M)
        LapTime2    : array[0..2] of Char;                    //bv^C(400M-200M)
        LapTime1    : array[0..2] of Char;                    //bv^C(200M-0M)
        crlf        : array[0..1] of Char;                    //R[h؂
    end;

    //***** Readobt@\̂ɃZbg֐̐錾*******************

    function SetDataTK(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_TK_TOKUUMA):boolean;
    function SetDataRA(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_RA_RACE):boolean;
    function SetDataSE(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_SE_RACE_UMA):boolean;
    function SetDataHR(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_HR_PAY):boolean;
    function SetDataH1(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_H1_HYOSU_ZENKAKE):boolean;
    function SetDataH6(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_H6_HYOSU_SANRENTAN):boolean;
    function SetDataO1(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O1_ODDS_TANFUKUWAKU):boolean;
    function SetDataO2(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O2_ODDS_UMAREN):boolean;
    function SetDataO3(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O3_ODDS_WIDE):boolean;
    function SetDataO4(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O4_ODDS_UMATAN):boolean;
    function SetDataO5(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O5_ODDS_SANREN):boolean;
    function SetDataO6(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_O6_ODDS_SANRENTAN):boolean;
    function SetDataUM(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_UM_UMA):boolean;
    function SetDataKS(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_KS_KISYU):boolean;
    function SetDataCH(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_CH_CHOKYOSI):boolean;
    function SetDataBR(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_BR_BREEDER):boolean;
    function SetDataBN(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_BN_BANUSI):boolean;
    function SetDataHN(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_HN_HANSYOKU):boolean;
    function SetDataSK(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_SK_SANKU):boolean;
    function SetDataRC(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_RC_RECORD):boolean;
    function SetDataHC(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_HC_HANRO):boolean;
    function SetDataWH(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_WH_BATAIJYU):boolean;
    function SetDataWE(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_WE_WEATHER):boolean;
    function SetDataAV(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_AV_INFO):boolean;
    function SetDataJC(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_JC_INFO):boolean;
    function SetDataTC(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_TC_INFO):boolean;
    function SetDataCC(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_CC_INFO):boolean;
    function SetDataDM(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_DM_INFO):boolean;
    function SetDataYS(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_YS_SCHEDULE):boolean;
    function SetDataHS(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_HS_SALE):boolean;
    function SetDataHY(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_HY_BAMEIORIGIN):boolean;
    function SetDataCK(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_CK_CHAKU):boolean;
    function SetDataBT(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_BT_KEITO):boolean;
    function SetDataCS(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_CS_COURSE):boolean;
    function SetDataTM(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_TM_INFO):boolean;
    function SetDataWF(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_WF_INFO):boolean;
    function SetDataJG(var Buff:WideString ; BuffSize:Integer ; var mbuf :JV_JG_JOGAIBA):boolean;

implementation

// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataTK(var Buff : WideString ;BuffSize :Integer;  var mbuf:JV_TK_TOKUUMA):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataTK := true;
except
    SetdataTK := false;
end;
end;

// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataRA(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_RA_RACE):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataRA := true;
except
    SetdataRA := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataSE(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_SE_RACE_UMA):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataSE := true;
except
    SetdataSE := false
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataHR(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_HR_PAY ):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataHR := true;
except
    SetdataHR := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataH1(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_H1_HYOSU_ZENKAKE ):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataH1 := true;
except
    SetdataH1 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataH6(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_H6_HYOSU_SANRENTAN ):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataH6 := true;
except
    SetdataH6 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO1(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O1_ODDS_TANFUKUWAKU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO1 := true;
except
    SetdataO1 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO2(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O2_ODDS_UMAREN):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO2 := true;
except
    SetdataO2 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO3(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O3_ODDS_WIDE):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO3 := true;
except
    SetdataO3 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO4(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O4_ODDS_UMATAN):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO4 := true;
except
    SetdataO4 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO5(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O5_ODDS_SANREN):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO5 := true;
except
    SetdataO5 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataO6(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_O6_ODDS_SANRENTAN):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataO6 := true;
except
    SetdataO6 := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataUM(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_UM_UMA):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataUM := true;
except
    SetdataUM := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataKS(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_KS_KISYU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataKS := true;
except
    SetdataKS := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataCH(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_CH_CHOKYOSI):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataCH := true;
except
    SetdataCH := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataBR(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_BR_BREEDER):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataBR := true;
except
    SetdataBR := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataBN(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_BN_BANUSI):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataBN := true;
except
    SetdataBN := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataHN(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_HN_HANSYOKU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataHN := true;
except
    SetdataHN := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataSK(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_SK_SANKU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataSK := true;
except
    SetdataSK := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataRC(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_RC_RECORD):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataRC := true;
except
    SetdataRC := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataHC(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_HC_HANRO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataHC := true;
except
    SetdataHC := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataWH(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_WH_BATAIJYU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataWH := true;
except
    SetdataWH := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataWE(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_WE_WEATHER):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataWE := true;
except
    SetdataWE := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataAV(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_AV_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataAV := true;
except
    SetdataAV := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataJC(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_JC_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataJC := true;
except
    SetdataJC := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataTC(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_TC_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataTC := true;
except
    SetdataTC := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataCC(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_CC_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataCC := true;
except
    SetdataCC := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataDM(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_DM_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataDM := true;
except
    SetdataDM := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataYS(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_YS_SCHEDULE):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataYS := true;
except
    SetdataYS := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataHS(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_HS_SALE):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataHS := true;
except
    SetdataHS := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataHY(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_HY_BAMEIORIGIN):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataHY := true;
except
    SetdataHY := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataCK(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_CK_CHAKU):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataCK := true;
except
    SetdataCK := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataBT(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_BT_KEITO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataBT := true;
except
    SetdataBT := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataCS(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_CS_COURSE):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataCS := true;
except
    SetdataCS := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataTM(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_TM_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataTM := true;
except
    SetdataTM := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataWF(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_WF_INFO):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataWF := true;
except
    SetdataWF := false;
end;
end;
// @(f)
//
// @\      :@Readobt@\̂ɃZbg
//
//     :  Buff |  , BuffSize | Int^ , mbuf | \
//
// Ԃl    :  True - , False - s
//
// @\  :  Readobt@\̂ɃZbg
//
function SetdataJG(var Buff : WideString ;BuffSize :Integer; var mbuf:JV_JG_JOGAIBA):boolean;
var
    MessageStr :String;
begin
try
    MessageStr:=Buff;
    strMove(@mbuf,pchar(MessageStr),BuffSize);
    SetdataJG := true;
except
    SetdataJG := false;
end;
end;
end.
